package java.lang;

/**
 * An instance ``wraps'' (or contains) a value of primitive type int.
 */
public final class Integer extends Number implements Comparable {
    /**
     * The smallest value of type int.
     */
    public static final int   MIN_VALUE = 0x80000000;

    /**
     * An object that wraps value v.
     */
    public Integer(int v) {
	this.value = v;
    }

    /**
     * = the value of this Integer.
     */
    public int intValue() {
	return value;
    }

    
    /** = a String representation of this Integer.
     */
    public String toString() {
	return String.valueOf(value);
    }

    
    
    /** = a positive integer, 0, or a negative integer, depending 
       on whether this Integer is greater than, equal to, or less than
       i. A ClassCastException is thrown if i is not an Integer.
     */
    public int compareTo(Integer i) {
	int thisVal = this.value;
	int anotherVal = i.value;
	return (thisVal<anotherVal ? -1 : (thisVal==anotherVal ? 0 : 1));
    }

}
